﻿EnableExplicit
;/------------------
;|
;| Template Version: 3
;|
;|
;| NEW SINCE VERSION 2:
;| Added three Parameters for Template_GetHeader()
;|
;| NEW SINCE VERSION 3:
;| Changed Returnvalues to INTEGER, added #USE_UNICODE and added possibility to set more anchors
;|
;/------------------

#TEMPLATE_VERSION = 3
;If i change anything with the procedures (add/delete Parameters or anything like this),
;the version may increment.
;This is to make sure, there will be no Stack-corruption and the template will not be used,
;till it gets updated to the new format.

CompilerIf #PB_Compiler_Unicode
	#USE_UNICODE = $8000
CompilerElse
	#USE_UNICODE = 0
CompilerEndIf

ProcedureDLL AttachProcess(Instance)
	;Called, when dll is loaded.
	;We do nothing but initialize our Global String-Variable
	Global HTML.s, CSS.s, CHARSET.s
	
EndProcedure

ProcedureDLL DetachProcess(Instance)
	;Called, when dll is unloaded.
	;Do you have anything to free?

	;No...
EndProcedure

Procedure.s Internal_DoHTML(CodeLine.s)
	;This procedure changes the CodeLine to make it "html-ready"
	Protected i, Add.s

	i = FindString(CodeLine, Chr(3))
	If i
		;Chr(3) will be used as a marker.
		;Anything before Chr(3) will be treated as html-code and should not get changed
		Add      = Left(CodeLine, i - 1)
		CodeLine = Mid(CodeLine, i + 1)
	EndIf
	CodeLine = ReplaceString(ReplaceString(CodeLine, "&", "&amp;"), " ", "&nbsp;")
	CodeLine = ReplaceString(CodeLine, #TAB$, "&nbsp;&nbsp;")
	CodeLine = ReplaceString(ReplaceString(CodeLine, "(", "&#40;"), ")", "&#41;")
	CodeLine = ReplaceString(ReplaceString(CodeLine, "<", "&lt;"), ">", "&gt;")
	CodeLine = ReplaceString(ReplaceString(CodeLine, Chr(34), "&quot;"), ":", "&#58;")
	CodeLine = RemoveString(CodeLine, Chr($EF) + Chr($BB) + Chr($BF))

	ProcedureReturn Add + CodeLine
EndProcedure

ProcedureDLL Template_SetCSS(NewCSS.s)
	
	If NewCSS
		CSS = NewCSS
	Else
		CSS = PeekS(?CSS_DEFAULT, -1, #PB_UTF8)
	EndIf
	
EndProcedure

ProcedureDLL Template_Init(Needed_Version)
	;When template-DLL has been successfully loaded,
	;HistoryViewer will call immediately Template_Init() to check
	;if this template has at least the Needed_Version.
	;
	;This is to check, if this version will work together with history viewer.
	;If Returnvalue & 1 <> #True, it will be unloaded immediately.
	Protected Result
	
	If Needed_Version <= #TEMPLATE_VERSION
		Result  = #True
		CHARSET = "ISO-8859-1"
		Template_SetCSS("")
	EndIf
	
	ProcedureReturn Result | #USE_UNICODE
EndProcedure

ProcedureDLL Template_SetCharset(_Charset.s)
	
	If _Charset
		CHARSET = _Charset
	Else
		CHARSET = "ISO-8859-1"
	EndIf
EndProcedure

ProcedureDLL Template_GetEmptySite()
	;The returned String will contain all of the html-code for displaying an empty site.
	
	HTML = "<html><head><title></title><style type='text/css'>" + #CRLF$
	HTML + CSS
	HTML + "</style></head><body>&nbsp;</body></html>"
	
	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_GetHeader(FileName.s, Title.s, Version, Date, BOM, ShowDifferences, User.s, LinesAdded, LinesDeleted)
	;Called, whenever an outputrequest has been made.
	;This procedure should return the pointer to a string, which contains anything necessary for a header.
	
	;You have a few Variables, which you can put into the html-code:
	;FileName:        This is the filename, the user selected.
	;Title:           User can set special title to versions.
	;                 This is given to you as link! and looks like this: [Title], or [] when emtpy.
	;Version:         The version-number of the shown history
	;Date:            Timestamp of the version
	;BOM:             if #PB_UTF8 you should set the charset of your output correctly
	;ShowDifferences: If <> 0 user activated the Code-Difference-View.
	;                 You may alter your header.
	;---Added since Version 2
	;User:            The Username, who made the changes (only used with postgresql)
	;LinesAdded:      The number of lines which have been added
	;LinesDeleted:    The number of lines which have been deleted
	
	HTML = "<html><head><title></title>" + #CRLF$
	HTML + "<meta http-equiv='content-type' content='text/html; charset="
	If BOM = #PB_UTF8
		HTML + "utf-8"
	Else
		HTML + CHARSET
	EndIf
	HTML + "' />" + #CRLF$
	HTML + "<style type='text/css'>" + #CRLF$
	HTML + CSS
	HTML + "</style>" + #CRLF$
	HTML + "</head>" + #CRLF$
	HTML + "<body>" + #CRLF$
	HTML + "<div class='filename'>" + FileName + "</div><br>" + #CRLF$
	HTML + "<table><tr>" + #CRLF$
	HTML + "<td>Version</td><td class='vars'>#" + Str(Version) + " [" + Title + "]</td></tr>" + #CRLF$
	If User
		HTML + "<tr><td>Made by:</td><td class='vars'>" + User + "</td></tr>" + #CRLF$
	EndIf
	HTML + "<tr><td>Created:</td><td class='vars'>" + FormatDate("%dd.%mm.%yyyy %hh:%ii:%ss", Date) + "</td></tr>" + #CRLF$
	If ShowDifferences
		HTML + "<tr><td>Lines Added:</td><td class='vars'>" + Str(LinesAdded) + "</td></tr>" + #CRLF$
		HTML + "<tr><td>Lines Deleted:</td><td class='vars'>" + Str(LinesDeleted) + "</td></tr>" + #CRLF$
	EndIf
	HTML + "</table><hr><br>" + #CRLF$
	HTML + "<table align='center' border='0' cellpadding='3' cellspacing='1' width='90%'><tbody>" + #CRLF$
	If ShowDifferences
		HTML + "<tr><td class='code_add'>Added Lines of Code</td></tr>" + #CRLF$
		HTML + "<tr><td class='code_del'>Deleted Lines of Code</td></tr>" + #CRLF$
		HTML + "<tr><td><br></td></tr>" + #CRLF$
	EndIf
	HTML + "<tr><td class='code'>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_GetFooter(ShowDifferences)
	;Called at the end of the output, so returnvalue should be anything which will make the html perfect.
	;
	;ShowDifferences: If <> 0 user activated the Code-Difference-View.
	;                 You may alter your footer.
	
	HTML = "</td></tr>" + #CRLF$
	If ShowDifferences
		HTML + "<tr><td><br></td></tr>" + #CRLF$
		HTML + "<tr><td class='code_add'>Added Lines of Code</td></tr>" + #CRLF$
		HTML + "<tr><td class='code_del'>Deleted Lines of Code</td></tr>" + #CRLF$
	EndIf
	HTML + "</tbody></table>" + #CRLF$
	HTML + "</body></html>" + #CRLF$

	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_DelBlockStart(Anchor.s)
	;This will be the start of a block, which contains deleted lines.
	;Anchor will be used to navigate within different changes in the code.
	
	HTML = "<a name=" + #DQUOTE$ + Anchor + #DQUOTE$ + "></a><div class='code_del'>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_DelBlockEnd()
	;This will be the end of the above block.
	
	HTML = "</div>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_DelBlockLine(Line.s)
	;One single line of code inside the block of deleted lines
	
	HTML = Internal_DoHTML(Line) + "<br>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure


ProcedureDLL Template_AddBlockStart(Anchor.s)
	;This will be the start of a block, which contains added lines.
	;Anchor will be used to navigate within different changes in the code.
	
	HTML = "<a name=" + #DQUOTE$ + Anchor + #DQUOTE$ + "></a><div class='code_add'>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_AddBlockEnd()
	;This will be the end of the above block.
	
	HTML = "</div>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_AddBlockLine(Line.s)
	;One single line of code inside the block of added lines
	
	HTML = Internal_DoHTML(Line) + "<br>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure

ProcedureDLL Template_AddLine(Line.s)
	;A single line of code
	
	HTML = Internal_DoHTML(Line) + "<br>" + #CRLF$
	
	ProcedureReturn @HTML
EndProcedure

DataSection
	CSS_DEFAULT:
	IncludeBinary "default.css"
	Data.c 0
EndDataSection


; IDE Options = PureBasic 5.31 (Windows - x86)
; ExecutableFormat = Shared Dll
; CursorPosition = 83
; FirstLine = 35
; Folding = ---
; EnableUnicode
; EnableXP
; Executable = default.dll
; CompileSourceDirectory
; EnableCompileCount = 25
; EnableBuildCount = 22
; EnableExeConstant